import { inject, TestBed } from '@angular/core/testing';
import { HttpModule } from "@angular/http";

import { LoggerComponent } from './logger.component';
import { LoggerService } from '../../core/logger/logger.service'
import { LoggingApiService } from '../../core/logger/logging-api.service'
import { ConfigService } from '../../core/config/config.service'
import { ConfigApiService } from '../../core/config/config-api.service'

describe('LoggerComponent', function () {
  let component: LoggerComponent
  let service: LoggerService
  let serviceApi: LoggingApiService

  beforeEach(function () {

    TestBed.configureTestingModule({
      imports: [HttpModule],
      providers: [LoggingApiService,
        LoggerService,
        ConfigService,
        ConfigApiService]
    })

  })

  beforeEach(inject([LoggingApiService, LoggerService],
    function (comp: LoggerComponent, serv: LoggerService, api: LoggingApiService) {
      component = new LoggerComponent(api, serv)
    }))

  it('should create', function () {
    expect(component).toEqual(jasmine.any(Object));
  })

  it('should have no rows', function () {
    expect(component.rows.length).toEqual(0);
  })

  it('should return rowClass DataTableRowError', function () {
    let rowClass: any
    rowClass = component.getRowClass({ type: '3' })
    expect(rowClass).toEqual(jasmine.any(Object));
    expect(typeof rowClass['DataTableRowError']).not.toEqual(undefined);
  })

  it('should return rowClass DataTableRowWarn', function () {
    let rowClass: any
    rowClass = component.getRowClass({ type: '4' })
    expect(rowClass).toEqual(jasmine.any(Object));
    expect(typeof rowClass['DataTableRowWarn']).not.toEqual(undefined);
  })

  it('should return rowClass DataTableRowDebug', function () {
    let rowClass: any
    rowClass = component.getRowClass({ type: '7' })
    expect(rowClass).toEqual(jasmine.any(Object));
    expect(typeof rowClass['DataTableRowDebug']).not.toEqual(undefined);
  })

  it('should return rowClass DataTableRowWarn', function () {
    let rowClass: any
    rowClass = component.getRowClass({})
    expect(rowClass).toEqual(jasmine.any(Object));
    expect(typeof rowClass['DataTableRowInfo']).not.toEqual(undefined);
  })

  afterEach(function () {

    TestBed.resetTestingModule()
  })

})
